#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define mSize 5

float normpdf(float x, float sigma)
{
	return 0.39894f*exp(-0.5f*x*x/(sigma*sigma))/sigma;
}

float hash( float n )
{
	float temp;
	return fract( sin(n)*54671.57391f, &temp);
}

float noise( vec2 p )
{
	return hash( p.x + p.y * 57.1235f );
}

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

static vec4 INPUT(image2d_t src_data, vec2 tc, __global FilterParam* param)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, tc.y) );
}

__kernel void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,
	  __global FilterParam* param,
	  int alpha)
{	
		float iGlobalTime = param->cur_time;
		
		
		int W = get_global_size(0);
		int H = get_global_size(1);

		vec2 resolution = (vec2)(W,H);
		int2 coordinate = (int2)(get_global_id0( param), get_global_id1( param));
		vec2 f_coordinate = (vec2)(get_global_id0( param), get_global_id1( param));
		vec2 tc = ((vec2)(coordinate.x, coordinate.y) + (vec2)(0.5f)) /resolution.xy;
		vec2 iResolution = (vec2)(W,H);
		
		vec4 orig = INPUT(src_data, tc, param);
		//declare stuff
		
		const int kSize = (mSize-1)/2;
		float blurKernel[mSize];
		vec3 final_colour = (vec3)(0.0f);
        vec3 col;
        vec2 offset;
        float ns;
		
		//create the 1-D blurKernel
		float sigma = 7.0f;
		float Z = 0.0f;
		for (int j = 0; j <= kSize; ++j)
		{
			blurKernel[kSize+j] = blurKernel[kSize-j] = normpdf((float)(j), sigma);
		}
		
		//get the normalization factor (as the gaussian has been clamped)
		for (int j = 0; j < mSize; ++j)
		{
			Z += blurKernel[j];
		}
		
		//read out the texels
		for (int i=-kSize; i <= kSize; ++i)
		{
			for (int j=-kSize; j <= kSize; ++j)
			{
                offset = (f_coordinate.xy+(vec2)(i*iResolution.x/1280.0f,j*iResolution.y/640.0f)) / iResolution.xy;
                col = INPUT(src_data,offset, param).xyz;
                ns = noise(  offset*(iGlobalTime+100.f) ) * 0.38f;
    			col = col * 0.68f + (vec3)(ns,ns,ns);
				final_colour += blurKernel[kSize+j]*blurKernel[kSize+i]*col.xxx;
			}
		}
		
		float4 outputCol = mix((vec4)(final_colour/(Z*Z), 1.0f), orig, (float4)(1.0f - (float)alpha/100.0f)); 
		write_imagef(dest_data, (int2)(get_global_id(0), get_global_id(1)), (vec4)(outputCol.xyz, orig.w));
		
}
